/*:
 * @target MZ
 * @plugindesc Shim — FontManager.clear() が無い環境にダミー実装を注入
 * @author HS
 */
(() => {
  'use strict';
  if (window.FontManager && typeof FontManager.clear !== 'function') {
    FontManager.clear = function() {
      try {
        if (this._urls) this._urls = {};
        if (this._states) this._states = {};
        if (this._requestQueue) this._requestQueue.length = 0;
      } catch (_) {}
    };
    console.info('HS_FontManagerClearShim: injected FontManager.clear()');
  }
})();
